import json
import sys
import os

def convert_json_to_jsonl(input_file, output_file):
    with open(input_file, 'r') as f:
        data = json.load(f)
    
    with open(output_file, 'w') as f:
        for item in data:
            f.write(json.dumps(item) + '\n')

for filename in os.listdir('.'):
    if filename.endswith('.json'):
        input_file = filename
        output_file = filename.replace('.json', '.jsonl')
        convert_json_to_jsonl(input_file, output_file)
        print(f"Converted {input_file} to {output_file}")

